/*
 * @(#)PythTest.java	
 *
 * Copyright (c) 1998 Tim Rinkens, Inc. All Rights Reserved.
 *
 */
import java.awt.*;
import java.applet.*;

public class Pythagor extends Applet {

    //public int PythModus = 0;

    PytControls controls;
    public void init() {
	BorderLayout bdl = new BorderLayout();
	//bdl.setHgap(10);
	setLayout(bdl);
	setBackground(Color.white);
	PytCanvas c = new PytCanvas();
	add("Center", c);
	controls = new PytControls(c);
	controls.setBackground(Color.blue);
	add("West", controls);
    }

    public void start() {
	controls.enable();
    }

    public void stop() {
	controls.disable();
    }

    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    System.exit(0);
	}
	return false;
    }

    public static void main(String className, String args[]) {
	Applet a;
	Dimension appletSize;

	try 
	       {
	          // create an instance of your applet class
	          a = (Applet) Class.forName(className).newInstance();
	       }
	       catch (ClassNotFoundException e) { return; }
	       catch (InstantiationException e) { return; }
	       catch (IllegalAccessException e) { return; }

	Frame f = new Frame("Pythagoras");
	Pythagor pytTest = new Pythagor();

	pytTest.init();
	pytTest.start();

	f.add("Center", pytTest);
	appletSize =  a.size();
	f.pack();
	f.resize(appletSize);  
	//f.resize(400, 400);
	f.show();
    }
}


class PytCanvas extends Canvas {
    double	degAngle = 45;
    double	radAngle = degAngle/180*Math.PI;
    boolean	filled = false;
    Font	font;
    //int PythModus = Pythagor.PythModus;
    boolean PythModus = false;
    //int pyth_modus = 0;
    double phi_r[][] = {{Math.cos(radAngle), Math.sin(radAngle)*(-1)}, 
		      {Math.sin(radAngle), Math.cos(radAngle) }};
    double phi_l[][] = {{Math.cos(Math.PI - radAngle), (Math.sin(Math.PI - radAngle))*(-1)}, 
		      {Math.sin(Math.PI - radAngle), Math.cos(Math.PI - radAngle) }};
    double PythScale[][] = new double[3][3];
    double bereich_x[] = new double[2];
    double bereich_y[] = new double[2];

    public void warteText(Graphics g, Rectangle r, String waitText[]) {

	int fontHeight	= g.getFontMetrics().getAscent();
	int strWidthMax = 0;
	int i = 0;
	while (waitText[i] != "#") { 
		if (g.getFontMetrics().stringWidth(waitText[i]) > strWidthMax) {
			strWidthMax = g.getFontMetrics().stringWidth(waitText[i]); }
		i++; }
	int j = i ;
	int x_pos = (int)((r.width - strWidthMax) / 2) - 10 ;
	int y_pos = (int)(r.height / 2 - (j / 2 + 1) * (fontHeight + 8)) ;
	int Twidth = (int)(strWidthMax + 20);
	int Theight = (int)((j +1)* (fontHeight + 8)) ; 
	g.fillRect(x_pos+4, y_pos+4, Twidth+4, Theight+4);
	g.clearRect(x_pos, y_pos, Twidth, Theight);	
	g.drawRect(x_pos, y_pos, Twidth, Theight);	
	for (i=0; i < j; i++) {
	    int strWidth	= g.getFontMetrics().stringWidth(waitText[i]);
	    g.drawString(waitText[i] , (int)((r.width - strWidth) / 2), 
				(int)(r.height / 2 - (j / 2 - i ) * (fontHeight + 8))); 
	}

    }

    public void koordinaten(double p0[], double p1[], 
		       double a, double b, double c, int PythSwitch) {
        if (c >= 1) {

	double v_p0_p1[]	= {(p1[0] - p0[0])/c, (p1[1] - p0[1])/c};
	double v_p2[]	= new double[2];
	double p2[]	= new double[2];
	double v_p0_r[] 	= new double[2];
	double v_p0_l[] 	= new double[2];
	double c_r;
	double c_l;

             if ((PythModus) && (PythSwitch == 0)) {
	v_p2[0]	= phi_l[0][0] * v_p0_p1[0] + phi_l[0][1] * v_p0_p1[1];
	v_p2[1]	= phi_l[1][0] * v_p0_p1[0] + phi_l[1][1] * v_p0_p1[1];
	
	p2[0]	= p1[0] + (b * v_p2[0]);
	p2[1]	= p1[1] + (b * v_p2[1]);
	v_p0_r[0]	= b * ((p2[0] - p0[0]) / a);
	v_p0_r[1]	= b * ((p2[1] - p0[1]) / a);
	v_p0_l[0]	= a * v_p2[0];
	v_p0_l[1]	= a * v_p2[1];
	c_r	= b;
	c_l	= a;
	PythSwitch = 1;

             } else {
	v_p2[0]	= phi_r[0][0] * v_p0_p1[0] + phi_r[0][1] * v_p0_p1[1]; 
	v_p2[1]	= phi_r[1][0] * v_p0_p1[0] + phi_r[1][1] * v_p0_p1[1];
	
	p2[0]	= p0[0] + (b * v_p2[0]);
	p2[1]	= p0[1] + (b * v_p2[1]);
	v_p0_r[0]	= a * v_p2[0];
	v_p0_r[1]	= a * v_p2[1];
	v_p0_l[0]	= b * ((p2[0] - p1[0]) / a);
	v_p0_l[1] 	= b * ((p2[1] - p1[1]) / a);
	c_r	= a;
	c_l	= b;
	PythSwitch = 0;
             }

	double p0_r[]	= {p2[0] + v_p0_r[0], p2[1] + v_p0_r[1]};
	double p1_r[]	= {p1[0] + v_p0_r[0], p1[1] + v_p0_r[1]};

	double p0_l[]	= {p0[0] + v_p0_l[0], p0[1] + v_p0_l[1]};
	double p1_l[]	= {p2[0] + v_p0_l[0], p2[1] + v_p0_l[1]}; 
	double a_r	= a * (c_r / c) ;
	double b_r	= b * (c_r / c) ;
	double a_l	= a * (c_l / c) ;
	double b_l	= b * (c_l / c) ;

	koordinaten(p0_r, p1_r, a_r, b_r, c_r, PythSwitch);
	koordinaten(p0_l, p1_l, a_l, b_l, c_l, PythSwitch);

         } else {
	if (p0[0] > bereich_x[1]) bereich_x[1] = p0[0];
	if (p0[0] < bereich_x[0]) bereich_x[0] = p0[0];
	if (p0[1] > bereich_y[1]) bereich_y[1] = p0[1];
	if (p0[1] < bereich_y[0]) bereich_y[0] = p0[1];
         }
    }

    public void dreieck(Graphics g, Rectangle r, double p0[], double p1[], 
		       double a, double b, double c, int PythSwitch) {
        if (c >= 1){

	double v_p0_p1[]	= {(p1[0] - p0[0])/c, (p1[1] - p0[1])/c};
	double v_p2[]	= new double[2];
	double p2[]	= new double[2];
	double v_p0_r[] 	= new double[2];
	double v_p0_l[] 	= new double[2];
	double c_r;
	double c_l;

             if ((PythModus) && (PythSwitch == 0)) {
	v_p2[0]	= phi_l[0][0] * v_p0_p1[0] + phi_l[0][1] * v_p0_p1[1];
	v_p2[1]	= phi_l[1][0] * v_p0_p1[0] + phi_l[1][1] * v_p0_p1[1];
	
	p2[0]	= p1[0] + (b * v_p2[0]);
	p2[1]	= p1[1] + (b * v_p2[1]);
	v_p0_r[0]	= b * ((p2[0] - p0[0]) / a);
	v_p0_r[1]	= b * ((p2[1] - p0[1]) / a);
	v_p0_l[0]	= a * v_p2[0];
	v_p0_l[1]	= a * v_p2[1];
	c_r	= b;
	c_l	= a;
	PythSwitch = 1;

             } else {
	v_p2[0]	= phi_r[0][0] * v_p0_p1[0] + phi_r[0][1] * v_p0_p1[1]; 
	v_p2[1]	= phi_r[1][0] * v_p0_p1[0] + phi_r[1][1] * v_p0_p1[1];
	
	p2[0]	= p0[0] + (b * v_p2[0]);
	p2[1]	= p0[1] + (b * v_p2[1]);
	v_p0_r[0]	= a * v_p2[0];
	v_p0_r[1]	= a * v_p2[1];
	v_p0_l[0]	= b * ((p2[0] - p1[0]) / a);
	v_p0_l[1] 	= b * ((p2[1] - p1[1]) / a);
	c_r	= a;
	c_l	= b;
	PythSwitch = 0;
             }

	double p0_r[]	= {p2[0] + v_p0_r[0], p2[1] + v_p0_r[1]};
	double p1_r[]	= {p1[0] + v_p0_r[0], p1[1] + v_p0_r[1]};

	double p0_l[]	= {p0[0] + v_p0_l[0], p0[1] + v_p0_l[1]};
	double p1_l[]	= {p2[0] + v_p0_l[0], p2[1] + v_p0_l[1]}; 
	double a_r	= a * (c_r / c) ;
	double b_r	= b * (c_r / c) ;
	double a_l	= a * (c_l / c) ;
	double b_l	= b * (c_l / c) ;
	double x_array[]	= {p0[0], p0_r[0], p1_r[0], p1[0], p1_l[0], p0_l[0], p0[0], p0[0]};
	
	double y_array[]	= {p0[1], p0_r[1], p1_r[1], 
			p1[1], p1_l[1], p0_l[1], 
			p0[1], p0[1]    };
	for (int i = 0; i < 6; i++) {
	    g.drawLine((int)(PythScale[0][0]*x_array[i] + PythScale[0][2]), 
			r.height + 1 - (int)(PythScale[1][1]*y_array[i] + PythScale[1][2] ),
			(int)(PythScale[0][0]*x_array[i+1] + PythScale[0][2]), 
			r.height + 1 - (int)(PythScale[1][1]*y_array[i+1] + PythScale[1][2]) ); }

	//g.drawPolyline(x_array, y_array, 7 );

	dreieck(g, r, p0_r, p1_r, a_r, b_r, c_r, PythSwitch);
	dreieck(g, r, p0_l, p1_l, a_l, b_l, c_l, PythSwitch);
         }
    }

    public void paint(Graphics g) {
          Rectangle r = bounds();

          g.setFont(new Font("Helvetica", Font.PLAIN, 14));
          //g.setColor(Color.pink);

          g.setColor(Color.black);
          g.setFont(font);
          //String waitText[] = new String[2];
          if ((degAngle > 85) || (degAngle < 5)) {
	String verhaeltnis;
	if (degAngle > 85) { verhaeltnis = "gross"; } else { verhaeltnis = "klein"; }
	String waitText[] = {"Sorry, der Winkel " + degAngle + " Grad ist",
			"leider zu "+verhaeltnis+". Die Anfangshypothenuse wuerde",
			"in diesem Fall zu einem Overflow fuehren.",
			"Bitte waehlen Sie einen anderen Winkel.", "#"};
	warteText(g, r, waitText);	

          } else {
	String waitText[] = {"Das Koordinatensystem fr alpha = " + degAngle + " Grad",
			"wird nun berechnet. Fr bestimmte Winkel kann",
			"diese Berechnung einige Sekunden in Anspruch nehmen.",
			"Ich bitte daher um etwas Geduld...", "#"};
	warteText(g, r, waitText);	

	double alpha	= radAngle;
	double start_c	= 80;

	//double cos_alpha	= Math.cos(alpha);
	//double sin_alpha	= Math.sin(alpha);

	double start_a = Math.sin(alpha) * start_c;                                                                                                       
	double start_b = Math.cos(alpha) * start_c;

	phi_r[0][0]	= Math.cos(alpha);
	phi_r[0][1]	= Math.sin(alpha) * (-1);
	phi_r[1][0]	= Math.sin(alpha);
	phi_r[1][1]	= Math.cos(alpha);

    	phi_l[0][0]	= Math.cos(Math.PI - alpha);
	phi_l[0][1]	= Math.sin(Math.PI - alpha) * (-1);
	phi_l[1][0]	= Math.sin(Math.PI - alpha);
	phi_l[1][1]	= Math.cos(Math.PI - alpha);

	double start_p0[]	= { (-1)*start_c/2, start_c};
	double start_p1[]	= {start_c/2, start_c};
	bereich_x[0] = start_p0[0];
	bereich_x[1] = start_p1[0];
	bereich_y[0] = 0;
	bereich_y[1] = start_p0[1];
	System.out.println("alpha = "+alpha);
	System.out.println("Abbildungsbereich: Breite: "+r.width+"  ,  Hoehe: "+r.height );
	koordinaten(start_p0, start_p1, start_a, start_b, start_c, 1);

	double bild_max = (double)(Math.min(r.width, r.height));
	double delta_x = (bereich_x[1] - bereich_x[0]);
	double delta_y = (bereich_y[1] - bereich_y[0]);
	double max_bereich = Math.max(delta_x, delta_y);
	System.out.println("bereich_x: "+(int)bereich_x[0]+" , "+(int)bereich_x[1]+"    delta: "+delta_x );
	System.out.println("bereich_y: "+(int)bereich_y[0]+" , "+(int)bereich_y[1]+"    delta: "+delta_y );
	double ScaleFaktor = Math.min(((double)r.width / (bereich_x[1] - bereich_x[0])), 
			((double)r.height / (bereich_y[1] - bereich_y[0])));
	PythScale[0][0] = ScaleFaktor ;
	PythScale[0][1] = 0 ;
	PythScale[0][2] = (-1)*bereich_x[0] * ScaleFaktor ;
	PythScale[1][0] = 0 ;
	PythScale[1][1] = ScaleFaktor ;
	PythScale[1][2] = (-1)*bereich_y[0] * ScaleFaktor ;
	PythScale[2][0] = 0 ;
	PythScale[2][1] = 0 ;
	PythScale[2][2] = 1 ;
	//PythScale[0][0] = r.width / (bereich_x[1] - bereich_x[0]);
	//PythScale[0][2] = (-1)*bereich_x[0] * ((double)r.width / (bereich_x[1] - bereich_x[0]));
	//PythScale[1][1] = ((double)r.height) / (bereich_y[1] - bereich_y[0]) ;
	//PythScale[1][2] = (-1)*bereich_y[0] * ((double)r.height / (bereich_y[1] - bereich_y[0]));
	System.out.println("ScaleFaktor: "+ScaleFaktor);
	System.out.println("P0=("+(int)start_p0[0]+", "+(int)start_p0[1]+")  ;  P1=("+
			(int)start_p1[0]+", "+(int)start_p1[1]+")");
	System.out.println("a="+start_a+"   ,   b="+start_b+"   ,   c="+start_c);
	g.clearRect(0, 0, r.width, r.height);
	//g.drawLine(0, 0, r.width-1, 0); g.drawLine(r.width-1, 0, r.width-1, r.height-1);
	//g.drawLine(r.width-1, r.height-1, 0, r.height-1); g.drawLine(0, r.height-1, 0, 0);
	double x_array[]	= {start_p0[0], start_p1[0], start_p1[0], 
			start_p0[0], start_p0[0], 
			start_p0[0] };
	double y_array[]	= {start_p0[1], start_p1[1], (start_p1[1] - start_c), 
			(start_p0[1] - start_c), start_p0[1], start_p0[1]};
	for (int i = 0; i < 5; i++) {
	    g.drawLine((int)(PythScale[0][0]*x_array[i] + PythScale[0][2]), 
			r.height - 1 - (int)(PythScale[1][1]*y_array[i] + PythScale[1][2]),
			(int)(PythScale[0][0]*x_array[i+1] + PythScale[0][2]), 
			r.height -1 - (int)(PythScale[1][1]*y_array[i+1] + PythScale[1][2]) ); }

	//g.drawPolyline(x_array, y_array, 5 );

	dreieck(g, r, start_p0, start_p1, start_a, start_b, start_c, 1);
          }
    }

    public void redraw(boolean pmodus, double deg, double rad) {
	this.PythModus = pmodus;
	this.degAngle = deg;
	this.radAngle = rad;
	repaint();
    }

}

class PytControls extends Panel {
    TextField deg_f;
    TextField rad_f;
    PytCanvas canvas;

    public PytControls(PytCanvas canvas) {
	this.canvas = canvas;
	//setLayout(new GridLayout(6,1));
	GridBagLayout gbl = new GridBagLayout();
	setLayout(gbl);
	GridBagConstraints GBC = new GridBagConstraints();
	GBC.gridx = 0;
	GBC.gridy = 0;
	GBC.gridwidth = 1;
	GBC.gridheight = 1;
	GBC.weightx = 1.0;
	GBC.insets = new Insets(0, 0, 20, 0);
	GBC.fill = GridBagConstraints.CENTER;
	Label gradLabel = new Label(" Grad: ");
	gradLabel.setFont(new Font("Helvetica", Font.BOLD, 14));
	gradLabel.setForeground(Color.yellow);
	gbl.setConstraints(gradLabel, GBC);
	add(gradLabel);
	GBC.gridy = 1;
	deg_f = new TextField("45", 10);
	deg_f.setBackground(Color.white);
	gbl.setConstraints(deg_f, GBC);
	add(deg_f);
	GBC.gridy = 2;
	Label radLabel = new Label(" Bogenma: ");
	radLabel.setFont(new Font("Helvetica", Font.BOLD, 14));
	radLabel.setForeground(Color.yellow);
	gbl.setConstraints(radLabel, GBC);
	add(radLabel);
	GBC.gridy = 3;
	rad_f = new TextField("0.7853", 10);
	rad_f.setBackground(Color.white);
	gbl.setConstraints(rad_f, GBC);
	add(rad_f);
	GBC.gridy = 4;
	Button PythButton = new Button("Pythagoras");
	gbl.setConstraints(PythButton, GBC);
	add(PythButton);
	GBC.gridy = 5;
	Button AlterButton = new Button("Alternierend");
	gbl.setConstraints(AlterButton, GBC);
	add(AlterButton);
    }

    public boolean action(Event ev, Object arg) {
	if (ev.target instanceof Button) {
	    String label = (String)arg;
	    //if (label.equals("Alternierend")) { Pythagor.PythModus = 1; } else {super.PythModus = 0; }

/*	    canvas.redraw(((label.equals("Pythagoras")) !! (label.equals("Alternierend"))),
			  //Integer.parseInt(s.getText().trim()),
			  Double.valueOf(deg_f.getText().trim()).doubleValue(),
			  Double.valueOf(rad_f.getText().trim()).doubleValue() );
			  //Integer.parseInt(e.getText().trim()));
*/
	    if (label.equals("Pythagoras")) {
			System.out.println("------------ Pythagoras gleichmig -------------");
			canvas.redraw(false, 
				Double.valueOf(deg_f.getText().trim()).doubleValue(),
				Double.valueOf(rad_f.getText().trim()).doubleValue() );
			}
	    if (label.equals("Alternierend")) {
			System.out.println("------------------- Alternierend ----------------------");
			canvas.redraw(true, 
				Double.valueOf(deg_f.getText().trim()).doubleValue(),
				Double.valueOf(rad_f.getText().trim()).doubleValue() );
			}


	    return true;
	}

	return false;
    }
    public boolean handleEvent (Event ev) {
       try {
        if (ev.target==rad_f) {  
	deg_f.setText(""+(Double.valueOf(rad_f.getText().trim()).doubleValue()/Math.PI*180)) ;
	}
        if (ev.target==deg_f) {  
	rad_f.setText(""+(Double.valueOf(deg_f.getText().trim()).doubleValue()*Math.PI/180)) ;
	}
        }
	catch (Exception e) {
	//statusLabel.setText("Hhmmm - "+e+"\n");
	System.out.println("Fehler "+e);
	}    

        return super.handleEvent(ev);            
     }

}
	
